import asyncio

import pytest

URL = "https://cloud-login.sigmacare.com/"

FAILURE_TEXT = "unsupported browser"


@pytest.mark.asyncio
@pytest.mark.with_interventions
async def test_enabled(client):
    await client.navigate(URL)
    await asyncio.sleep(3)
    assert not client.find_text(FAILURE_TEXT, is_displayed=True)


@pytest.mark.asyncio
@pytest.mark.without_interventions
async def test_disabled(client):
    await client.navigate(URL)
    assert client.await_text(FAILURE_TEXT, is_displayed=True)
