<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Form\Tests\Extension\Validator\Type;

use Symfony\Component\Form\Extension\Core\Type\CheckboxType;

class CheckboxTypeValidatorExtensionTest extends BaseValidatorExtensionTestCase
{
    protected function createForm(array $options = [])
    {
        return $this->factory->create(CheckboxType::class, null, $options);
    }

    public function testInvalidMessage()
    {
        $form = $this->createForm();

        $this->assertSame('The checkbox has an invalid value.', $form->getConfig()->getOption('invalid_message'));
    }
}
