+++
title = "htmx 2.0.0 has been released!"
date = 2024-06-17
[taxonomies]
tag = ["posts", "announcements"]
+++

## htmx 2.0.0 Release

I'm very happy to announce the release of htmx 2.0.  This release ends support for Internet Explorer and tightens up some
defaults, but does not change most of the core functionality or the core API of the library.

Note that we are not marking 2.0 as [`latest`](https://docs.npmjs.com/cli/v10/commands/npm-dist-tag#purpose) in NPM 
because we do not want to force-upgrade users who are relying on non-versioned CDN URLs for htmx.  Instead, 1.x will
remain `latest` and the 2.0 line will remain `next` until Jan 1, 2025. The website, however, will reference 2.0.

### Major Changes

* All extensions have been moved out of the core repository to [their own repo](https://github.com/bigskysoftware/htmx-extensions/)
  and website: <https://extensions.htmx.org>.  They are now all versioned individually and can be developed outside of
  the normal (slow) htmx release cadence.
  * Most 1.x extensions will work with 2.x, however the SSE extension did have a break and must be upgraded.
  * The older extensions remain in the `/dist/ext` directory so as to not break the URLs of CDNs like unpkg, but please
    move to the new extension URLs going forward
* We removed the deprecated `hx-sse` and `hx-ws` attributes in favor of the extensions, which were available and
  recommended in 1.x.
* HTTP `DELETE` requests now use parameters, rather than form encoded bodies, for their payload (This is in accordance w/ the spec.)
* We now provide specific files in `/dist` for the various JavaScript module styles:
  * ESM Modules: `/dist/htmx.esm.js`
  * AMD Modules: `/dist/htmx.amd.js`
  * CJS Modules: `/dist/htmx.cjs.js`
  * The `/dist/htmx.js` file continues to be browser-loadable
* The `hx-on` attribute, with its special syntax, has been removed in favor of the less-hacky `hx-on:` syntax.

### Minor Changes

* We made some default changes:
  * `htmx.config.scrollBehavior` was changed to `'instant'` from `'smooth'`
  * As mentioned previously, `DELETE` requests now use query parameters, rather than a form-encoded body.  This can
    be reverted by setting `htmx.methodsThatUseUrlParams` to  the value `['get']`,
  * `htmx.config.selfRequestsOnly` now defaults to `true` rather than `false`

### Features

Not much, really:

* The `selectAndSwap()` internal API method was replaced with the public (and much better) [`swap()`](/api/#swap) method
* Web Component support has been [improved dramatically](@/examples/web-components.md)
* And the biggest feature of this release: [the website](https://htmx.org) now supports dark mode! (Thanks [@pokonski](https://github.com/pokonski)!)

A complete upgrade guide can be found here:

[htmx 1.x -> 2.x Migration Guide](@/migration-guide-htmx-1.md)

If you require IE compatibility, the [1.x](https://v1.htmx.org) will continue to be supported for the foreseeable future.

### Installing

htmx 2.0 can be installed via a package manager referencing version `2.0.0`, or can be linked via a CDN:

```html
<script src="https://unpkg.com/htmx.org@2.0.0/dist/htmx.min.js"></script>
```

or <a href="https://unpkg.com/htmx.org@2.0.0/dist/htmx.min.js" download>Downloaded</a>
