#pragma once
/*
 *  $Id: level.h 29016 2025-12-16 18:56:06Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_LEVEL_H__
#define __GWY_LEVEL_H__

#include <libgwyddion/utils.h>
#include <libgwyddion/field.h>

G_BEGIN_DECLS

void       gwy_line_fit_line                  (GwyLine *line,
                                               gdouble *a,
                                               gdouble *b);
void       gwy_line_line_level                (GwyLine *line,
                                               gdouble a,
                                               gdouble b);
void       gwy_line_rotate                    (GwyLine *line,
                                               gdouble angle,
                                               GwyInterpolationType interpolation);
gdouble*   gwy_line_part_fit_poly             (GwyLine *line,
                                               gint pos,
                                               gint len,
                                               gint n,
                                               gdouble *coeffs);
gdouble*   gwy_line_fit_poly                  (GwyLine *line,
                                               gint n,
                                               gdouble *coeffs);
void       gwy_line_part_subtract_poly        (GwyLine *line,
                                               gint pos,
                                               gint len,
                                               gint n,
                                               const gdouble *coeffs);
void       gwy_line_subtract_poly             (GwyLine *line,
                                               gint n,
                                               const gdouble *coeffs);
void       gwy_field_area_fit_plane           (GwyField *field,
                                               GwyField *mask,
                                               GwyMaskingType masking,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gdouble *pa,
                                               gdouble *pbx,
                                               gdouble *pby);
gint       gwy_NIELD_area_fit_plane           (GwyField *field,
                                               GwyNield *mask,
                                               GwyMaskingType masking,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gdouble *a,
                                               gdouble *bx,
                                               gdouble *by);
gint       gwy_field_fit_plane                (GwyField *field,
                                               gdouble *a,
                                               gdouble *bx,
                                               gdouble *by);
gboolean   gwy_field_fit_facet_plane          (GwyField *field,
                                               GwyField *mfield,
                                               GwyMaskingType masking,
                                               gdouble *a,
                                               gdouble *bx,
                                               gdouble *by);
gboolean   gwy_field_facet_level              (GwyField *field,
                                               GwyField *mask,
                                               GwyMaskingType masking,
                                               gint maxiter,
                                               GwySetFractionFunc set_fraction);
gboolean   gwy_NIELD_fit_facet_plane          (GwyField *field,
                                               GwyNield *mask,
                                               GwyMaskingType masking,
                                               gdouble *a,
                                               gdouble *bx,
                                               gdouble *by);
gboolean   gwy_NIELD_facet_level              (GwyField *field,
                                               GwyNield *mask,
                                               GwyMaskingType masking,
                                               gint maxiter,
                                               GwySetFractionFunc set_fraction);
void       gwy_field_plane_level              (GwyField *field,
                                               gdouble a,
                                               gdouble bx,
                                               gdouble by);
void       gwy_field_plane_rotate             (GwyField *field,
                                               gdouble xangle,
                                               gdouble yangle,
                                               GwyInterpolationType interpolation);
gdouble*   gwy_field_fit_legendre             (GwyField *field,
                                               gint col_degree,
                                               gint row_degree,
                                               gdouble *coeffs);
gdouble*   gwy_field_area_fit_legendre        (GwyField *field,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint col_degree,
                                               gint row_degree,
                                               gdouble *coeffs);
void       gwy_field_subtract_legendre        (GwyField *field,
                                               gint col_degree,
                                               gint row_degree,
                                               const gdouble *coeffs);
void       gwy_field_area_subtract_legendre   (GwyField *field,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint col_degree,
                                               gint row_degree,
                                               const gdouble *coeffs);
gdouble*   gwy_field_fit_poly_max             (GwyField *field,
                                               gint max_degree,
                                               gdouble *coeffs);
gdouble*   gwy_field_area_fit_poly_max        (GwyField *field,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint max_degree,
                                               gdouble *coeffs);
void       gwy_field_subtract_poly_max        (GwyField *field,
                                               gint max_degree,
                                               const gdouble *coeffs);
void       gwy_field_area_subtract_poly_max   (GwyField *field,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint max_degree,
                                               const gdouble *coeffs);
gdouble*   gwy_field_fit_poly                 (GwyField *field,
                                               GwyField *mask_field,
                                               GwyMaskingType masking,
                                               gint nterms,
                                               const gint *term_powers,
                                               gdouble *coeffs);
gdouble*   gwy_field_area_fit_poly            (GwyField *field,
                                               GwyField *mask_field,
                                               GwyMaskingType masking,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint nterms,
                                               const gint *term_powers,
                                               gdouble *coeffs);
gdouble*   gwy_NIELD_fit_poly                 (GwyField *field,
                                               GwyNield *mask_NIELD,
                                               GwyMaskingType masking,
                                               gint nterms,
                                               const gint *term_powers,
                                               gdouble *coeffs);
gdouble*   gwy_NIELD_area_fit_poly            (GwyField *field,
                                               GwyNield *mask_NIELD,
                                               GwyMaskingType masking,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint nterms,
                                               const gint *term_powers,
                                               gdouble *coeffs);
void       gwy_field_subtract_poly            (GwyField *field,
                                               gint nterms,
                                               const gint *term_powers,
                                               const gdouble *coeffs);
void       gwy_field_area_subtract_poly       (GwyField *field,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint nterms,
                                               const gint *term_powers,
                                               const gdouble *coeffs);
GwyField** gwy_field_area_fit_local_planes    (GwyField *field,
                                               gint size,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               gint nresults,
                                               const GwyPlaneFitQuantity *types,
                                               GwyField **results);
GwyField*  gwy_field_area_local_plane_quantity(GwyField *field,
                                               gint size,
                                               gint col,
                                               gint row,
                                               gint width,
                                               gint height,
                                               GwyPlaneFitQuantity type,
                                               GwyField *result);
GwyField** gwy_field_fit_local_planes         (GwyField *field,
                                               gint size,
                                               gint nresults,
                                               const GwyPlaneFitQuantity *types,
                                               GwyField **results);
GwyField*  gwy_field_local_plane_quantity     (GwyField *field,
                                               gint size,
                                               GwyPlaneFitQuantity type,
                                               GwyField *result);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
