#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Wallace and Gromit's Grand Adventures:
# - Episode 1: Fright of the Bumblebees
# - Episode 2: The Last Resort
# - Episode 3: Muzzled
# - Episode 4: The Bogey Man
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240904.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='wallace-and-gromits-grand-adventures'
GAME_NAME='Wallace & Gromit’s Grand Adventures'

GAME_ID_EPISODE1="${GAME_ID}-1"
GAME_NAME_EPISODE1="${GAME_NAME}: Episode 1 - Fright of the Bumblebees"

GAME_ID_EPISODE2="${GAME_ID}-2"
GAME_NAME_EPISODE2="${GAME_NAME}: Episode 2 - The Last Resort"

GAME_ID_EPISODE3="${GAME_ID}-3"
GAME_NAME_EPISODE3="${GAME_NAME}: Episode 3 - Muzzled"

GAME_ID_EPISODE4="${GAME_ID}-4"
GAME_NAME_EPISODE4="${GAME_NAME}: Episode 4 - The Bogey Man"

ARCHIVE_BASE_EPISODE1_0_NAME='setup_wallace_and_gromits_episode_1_-_fright_of_the_bumblebees_1.0_(43021).exe'
ARCHIVE_BASE_EPISODE1_0_MD5='386ad98408eb197081e9b45217759bed'
ARCHIVE_BASE_EPISODE1_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_0_SIZE='450000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0-gog43021'
ARCHIVE_BASE_EPISODE1_0_URL='https://www.gog.com/game/wallace_gromits_grand_adventures'

ARCHIVE_BASE_EPISODE2_0_NAME='setup_wallace_and_gromits_episode_2_-_the_last_resort_1.0_(43021).exe'
ARCHIVE_BASE_EPISODE2_0_MD5='d791a520c88c613c577b556de6d1276c'
ARCHIVE_BASE_EPISODE2_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_0_SIZE='610000'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.0-gog43021'
ARCHIVE_BASE_EPISODE2_0_URL='https://www.gog.com/game/wallace_gromits_grand_adventures'

ARCHIVE_BASE_EPISODE3_0_NAME='setup_wallace_and_gromits_episode_3_muzzled_2.0_(42668).exe'
ARCHIVE_BASE_EPISODE3_0_MD5='e33fe7ce94d9ee2ca33895c1cf349c29'
ARCHIVE_BASE_EPISODE3_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE3_0_SIZE='480000'
ARCHIVE_BASE_EPISODE3_0_VERSION='2.0-gog42668'
ARCHIVE_BASE_EPISODE3_0_URL='https://www.gog.com/game/wallace_gromits_grand_adventures'

ARCHIVE_BASE_EPISODE4_0_NAME='setup_wallace_and_gromits_episode_4_-_the_bogey_man_1.0_(43022).exe'
ARCHIVE_BASE_EPISODE4_0_MD5='1bd26fe8706be1d452bbcebd8a31a1fb'
ARCHIVE_BASE_EPISODE4_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE4_0_SIZE='560000'
ARCHIVE_BASE_EPISODE4_0_VERSION='1.0-gog43022'
ARCHIVE_BASE_EPISODE4_0_URL='https://www.gog.com/game/wallace_gromits_grand_adventures'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
fmodex.dll
wallacegromit101.exe
wallacegromit102.exe
wallacegromit103.exe
wallacegromit104.exe
language_setup.exe
language_setup.ini
language_setup.png'
CONTENT_GAME_DATA_FILES='
pack'

WINE_PERSISTENT_DIRECTORIES_EPISODE1='
users/${USER}/Documents/Telltale Games/wallace-and-gromit-1'
WINE_PERSISTENT_DIRECTORIES_EPISODE2='
users/${USER}/Documents/Telltale Games/wallace-and-gromit-2'
WINE_PERSISTENT_DIRECTORIES_EPISODE3='
users/${USER}/Documents/Telltale Games/wallace-and-gromit-3'
WINE_PERSISTENT_DIRECTORIES_EPISODE4='
users/${USER}/Documents/Telltale Games/wallace-and-gromit-4'

APP_MAIN_EXE_EPISODE1='wallacegromit101.exe'
APP_MAIN_EXE_EPISODE2='wallacegromit102.exe'
APP_MAIN_EXE_EPISODE3='wallacegromit103.exe'
APP_MAIN_EXE_EPISODE4='wallacegromit104.exe'

APP_LANGUAGE_ID_EPISODE1="${GAME_ID_EPISODE1}-language-setup"
APP_LANGUAGE_ID_EPISODE2="${GAME_ID_EPISODE2}-language-setup"
APP_LANGUAGE_ID_EPISODE3="${GAME_ID_EPISODE3}-language-setup"
APP_LANGUAGE_ID_EPISODE4="${GAME_ID_EPISODE4}-language-setup"
APP_LANGUAGE_NAME_EPISODE1="$GAME_NAME_EPISODE1 - Language setup"
APP_LANGUAGE_NAME_EPISODE2="$GAME_NAME_EPISODE2 - Language setup"
APP_LANGUAGE_NAME_EPISODE3="$GAME_NAME_EPISODE3 - Language setup"
APP_LANGUAGE_NAME_EPISODE4="$GAME_NAME_EPISODE4 - Language setup"
APP_LANGUAGE_EXE='language_setup.exe'
APP_LANGUAGE_CAT='Settings'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Ensure easy upgrades from packages generated with pre-20240704.5 game scripts.
PKG_BIN_PROVIDES_EPISODE1="${PKG_BIN_PROVIDES_EPISODE1:-}
wallace-and-gromit-1"
PKG_BIN_PROVIDES_EPISODE2="${PKG_BIN_PROVIDES_EPISODE2:-}
wallace-and-gromit-2"
PKG_BIN_PROVIDES_EPISODE3="${PKG_BIN_PROVIDES_EPISODE3:-}
wallace-and-gromit-3"
PKG_BIN_PROVIDES_EPISODE4="${PKG_BIN_PROVIDES_EPISODE4:-}
wallace-and-gromit-4"

PKG_DATA_ID_EPISODE1="${GAME_ID_EPISODE1}-data"
PKG_DATA_ID_EPISODE2="${GAME_ID_EPISODE2}-data"
PKG_DATA_ID_EPISODE3="${GAME_ID_EPISODE3}-data"
PKG_DATA_ID_EPISODE4="${GAME_ID_EPISODE4}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure easy upgrades from packages generated with pre-20240704.5 game scripts.
PKG_DATA_PROVIDES_EPISODE1="${PKG_DATA_PROVIDES_EPISODE1:-}
wallace-and-gromit-1-data"
PKG_DATA_PROVIDES_EPISODE2="${PKG_DATA_PROVIDES_EPISODE2:-}
wallace-and-gromit-2-data"
PKG_DATA_PROVIDES_EPISODE3="${PKG_DATA_PROVIDES_EPISODE3:-}
wallace-and-gromit-3-data"
PKG_DATA_PROVIDES_EPISODE4="${PKG_DATA_PROVIDES_EPISODE4:-}
wallace-and-gromit-4-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
